/* -*- mode: C; -*- */

/*
  Copyright (c) 1997-2002 MathEngine PLC

  $Name: t-stevet-RWSpre-030110 $

  Date: $Date: 2002/04/15 11:56:32 $ - Revision: $Revision: 1.1.2.5 $

  This software and its accompanying manuals have been developed
  by MathEngine PLC ("MathEngine") and the copyright and all other
  intellectual property rights in them belong to MathEngine. All
  rights conferred by law (including rights under international
  copyright conventions) are reserved to MathEngine. This software
  may also incorporate information which is confidential to
  MathEngine.

  Save to the extent permitted by law, or as otherwise expressly
  permitted by MathEngine, this software and the manuals must not
  be copied (in whole or in part), re-arranged, altered or adapted
  in any way without the prior written consent of the Company. In
  addition, the information contained in the software may not be
  disseminated without the prior written consent of MathEngine.

 */

/*
 * NGC implementation of platform specific timer functionality.
 *
 */

#include <time.h>
#include <unistd.h>
#include <dolphin/base/PPCArch.h>
#include <MeMessage.h>
#include <MePrecision.h>
#include <MeProfile.h>

extern MeI64 clockSpeed;
extern MeProfileTimerResult frameTime;

static unsigned control0;
static unsigned control1;

void MEAPI GetOutputInfo()
{
    /* get approximation of clock speed */
    clockSpeed = 486000000LL;
}

int MEAPI MeProfileStartHardwareTimer()
{
    frameTime.cpuCycles = 0;
    frameTime.count0 = 0;
    frameTime.count1 = 0;

reset:
    PPCMtpmc1(0); PPCMtpmc2(0); PPCMtpmc3(0); PPCMtpmc4(0);

start:
    PPCMtmmcr0(control0); PPCMtmmcr1(control1);
}

void MEAPI MeProfileGetTimerValue(MeProfileTimerResult *const result)
{
    result->cpuCycles = PPCMfpmc4();
    result->count0 = PPCMfpmc3();
    result->count1 = PPCMfpmc2();
}

int MEAPI MeProfileStopHardwareTimer()
{
stop:
    /* this ought to be done in the 1-0 order because CR1 contains
       the instruction count */
    PPCMtmmcr1(MMCR1_PMC3_HOLD | MMCR1_PMC4_HOLD);
    PPCMtmmcr0(MMCR0_PMC1_HOLD | MMCR0_PMC2_HOLD);

reset:
    PPCMtpmc1(0); PPCMtpmc2(0); PPCMtpmc3(0); PPCMtpmc4(0);

    return 0;
}

int MEAPI MeProfileCreateHardwareTimer(MeProfileTimerMode mode)
{
    GetOutputInfo();

    /*
        CR0 has counters 1 and 2, and CR1 has counters 3  and 4. All
        counters can count these:

            MMCR[01]_PMC[1234]_HOLD
            MMCR[01]_PMC[1234]_CYCLE
            MMCR[01]_PMC[1234]_INSTRUCTION
            MMCR[01]_PMC[1234]_TRANSITION
            MMCR[01]_PMC[1234]_DISPATCHED

        Then each counter has some specialized functions, and we can be
        interested in, for example:

            MMCR1_PMC3_FPU               instructions completed from the FPU
            MMCR1_PMC4_INTEGER           completed integer operations
            MMCR0_PMC2_LOAD_STORE        completed loads and stores

            MMCR1_PMC3_DC_MISS           L1 data cache misses
            MMCR0_PMC2_IC_MISS           L1 instruction cache misses
            MMCR0_PMC1_L1_MISS           loads that miss the L1
            MMCR1_PMC3_L1_MISS_CYCLE     cycles generated by L1 load misses

            MMCR1_PMC3_L2_D_MISS         L2 data misses
            MMCR0_PMC2_L2_I_MISS         L2 instruction misses
            MMCR0_PMC1_L2_HIT            access that hit the L2.
            MMCR1_PMC3_L2_HIT            cache operations that hit in the L2 cache

        As it is not otherwise much use, we always use counter 4
        for the cycle count, and we have 'count0' as counter 3 and
        'count1' as counter 0.
    */

    switch(mode.counterMode)
    {
    case kMeProfileCounterModeFlops:
        /*
            count0: VU0 macro-ops
            count1: floating point ops
        */
        control0 = (MMCR0_PMC1_L1_MISS | MMCR0_PMC2_LOAD_STORE);

        control1 = (MMCR1_PMC3_FPU | MMCR1_PMC4_CYCLE);
        *(mode.count0Label) = "FPU";
        *(mode.count1Label) = "LD/ST";
        break;

    /* To get the time wasted due to cache misses, we need the number
       of instructions issued and the number of cpu cycles */
    case kMeProfileCounterModeCache:
        /*
            count0: single cycle instructions issued
            count1: dual cycle instructions issued
        */
        control0 = (MMCR0_PMC1_L1_MISS | MMCR0_PMC2_LOAD_STORE);
        control1 = (MMCR1_PMC3_INSTRUCTION | MMCR1_PMC4_CYCLE);

        *(mode.count0Label) = "INS#";
        *(mode.count1Label) = "LD/ST";
        break;
    }

    return 0;
}

int MEAPI MeProfileDestroyHardwareTimer()
{
    return MeProfileStopHardwareTimer();
}
